// Scilab : 6.0.0
// OS: Windows 7, 64 bit
// Expt. No. 9: To design a Lag Compensator by Bode-plot technique

clc
close
clf();

s=poly(0,'s')
// Transfer Function of Open-Loop System
G=syslin('c',30/((s)*(0.1*s+1)*(0.2*s+1)))
figure(0)
// Bode - Plot of Un-Compensated System
bode(G,0.1,100)

[gm,frg]=g_margin(G);
disp(gm,"Gain Margin",frg,"Phase Cut-off Frequency")
show_margins(G)
[phm,frp]=p_margin(G);
disp(phm,"Phase Margin",frp,"Gain Cut-off Frequency")
show_margins(G)

// Transfer Function of Open-Loop Compensated System, GGc
GGc=syslin('c',30*(1+3.33*s)/((s)*(0.1*s+1)*(0.2*s+1)*(1+33.3*s)))

// Bode - Plot of Compensated System
figure(1)
bode(GGc,0.1,100)

[gm,frg]=g_margin(GGc);
disp(gm,"Gain Margin",frg,"Phase Cut-off Frequency")
show_margins(GGc)
[phm,frp]=p_margin(GGc);
disp(phm,"Phase Margin",frp,"Gain Cut-off Frequency")
show_margins(GGc)

// Step Response of Closed-Loop Un-Compensated System
figure(2)
t= 0:0.1:10;
x=[csim('step',t,G/(1+G))]';
plot2d(t',x),xgrid(5, 1, 7)
xlabel("t", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
xtitle( 'Step Response of Un-Compensated System');

// Step Response of Closed-Loop Compensated System
figure(3)
t= 0:0.1:10;
x=[csim('step',t,GGc/(1+GGc))]';
plot2d(t',x),xgrid(5, 1, 7)
xlabel("t", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
xtitle( 'Step Response of Compensated System');

// Result
// Frequency Response Specifications of Un-Compensated System
//Phase Cut-off Frequency
//
//   1.1253954
//
// Gain Margin
//
//  -6.0205999
//
// Gain Cut-off Frequency
//
//   1.555363
//
// Phase Margin
//
//  -17.245408
// Frequency Response Specifications of Compensated System

// Phase Cut-off Frequency
//
//   1.0788163
//
// Gain Margin
//
//   13.24356
//
// Gain Cut-off Frequency
//
//   0.4129329
//
// Phase Margin
//
//   42.090918
//
